;(function($){
	<?php
	if ( ! isset( $settings->item_html_tag ) ) {
		$settings->item_html_tag = $module->get_item_html_tag();
	}
	if ( ! isset( $settings->layout_style ) ) {
		$settings->layout_style = $module->get_layout_style();
	}
	$columns_desktop = empty( $settings->product_columns ) ? 3 : intval( $settings->product_columns );
	$columns_medium = empty( $settings->product_columns_medium ) ? $columns_desktop : intval( $settings->product_columns_medium );
	$columns_responsive = empty( $settings->product_columns_responsive ) ? $columns_medium : intval( $settings->product_columns_responsive );

	$scrollTo = apply_filters( 'woopack_products_grid_scroll_on_filter', true );
	?>

    var WooPackGridOptions = {
        id: '<?php echo $id ?>',
		layout: '<?php echo $settings->product_layout; ?>',
		layoutStyle: <?php echo $settings->product_layout; ?>,
		isCustomLayout: <?php echo isset( $settings->layout ) && 'custom' === $settings->layout ? 'true' : 'false'; ?>,
		columns: {
			desktop: <?php echo $columns_desktop; ?>,
			medium: <?php echo $columns_medium; ?>,
			responsive: <?php echo $columns_responsive; ?>,
		},
		pagination: '<?php echo $settings->pagination; ?>',
        perPage: '<?php echo $settings->posts_per_page; ?>',
		matchHeight: '<?php echo $settings->match_height; ?>',
        filters: '<?php echo $settings->enable_filter; ?>',
        filterTax: '<?php echo $settings->filter_taxonomy; ?>',
        filterType: '<?php echo $settings->filter_type; ?>',
		defaultFilter: '<?php echo isset( $settings->filter_term_default ) && ! empty( $settings->filter_term_default ) ? $settings->filter_term_default : ''; ?>',
        fields: <?php echo json_encode($settings); ?>,
		template: '<?php echo isset( $settings->quick_view_template ) ? $settings->quick_view_template : ''; ?>',
		imagesSlider: <?php echo isset( $settings->image_slider ) && 'yes' === $settings->image_slider ? 'true' : 'false'; ?>,
		siteUrl: '<?php echo site_url(); ?>',
		scrollTo: <?php echo $scrollTo ? 'true' : 'false'; ?>,
    };

    <?php if ( isset( $_GET['orderby'] ) && ! empty( $_GET['orderby'] ) ) { ?>
    WooPackGridOptions.orderby = '<?php echo wc_clean( (string) $_GET['orderby'] ); ?>';
    <?php } ?>

	<?php if ( is_archive() || is_post_type_archive() ) { ?>
		WooPackGridOptions.is_archive = true;
	<?php } ?>

	<?php if ( is_tax() || is_category() ) { ?>
		WooPackGridOptions.is_tax = true;
	<?php } ?>

	<?php if ( isset( get_queried_object()->taxonomy ) && isset( get_queried_object()->slug ) ) { ?>
		WooPackGridOptions.current_tax = '<?php echo get_queried_object()->taxonomy; ?>';
		WooPackGridOptions.current_term = '<?php echo get_queried_object()->slug; ?>';
	<?php } ?>

	<?php if ( is_author() ) { ?>
	WooPackGridOptions.is_author = true;
	WooPackGridOptions.current_author = '<?php echo get_queried_object()->ID; ?>';
	<?php } ?>

	<?php if ( is_search() ) { ?>
	WooPackGridOptions.is_search = true;
	WooPackGridOptions.search_term = '<?php echo isset( $_GET['s'] ) ? (string) $_GET['s'] : ''; ?>';
	<?php } ?>

    woopack_<?php echo $id; ?> = new WooPackGrid( WooPackGridOptions );

	// Layout fix in PowerPack Advanced Tabs module
	$(document).on('pp-tabs-switched', function(e, selector) {
		if ( selector.find('.woopack-grid-wrap').length > 0 ) {
			var wrap = selector.find('#woopack-<?php echo $id; ?> .woopack-products');
			if ( 'undefined' !== typeof $.fn.isotope && 'undefined' !== typeof $.fn.imagesLoaded ) {
				setTimeout(function() {
					if ( ! wrap.hasClass('woopack-isotope-initialized') ) {
						wrap.imagesLoaded(function() {
							var hasSlider = false;
							if ( wrap.find( '.slick-slider' ).length > 0 ) {
								hasSlider = true;
								wrap.find( '.slick-slider' ).slick('unslick');
							}
							if ( ! wrap.data('isotope') ) {
								wrap.isotope( woopack_<?php echo $id; ?>.isotopeData );
							}
							if ( hasSlider ) {
								woopack_<?php echo $id; ?>._initSlider();
							}

							wrap.isotope('layout');
							wrap.addClass('woopack-isotope-initialized');
						});
					}
				}, 500);
			}
		}
	});

})(jQuery);
